#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include "e521.h"

int main(int argc, char* argv[])
{
    const int len_seed = 256;

    uint8_t kbuf_pub[E521_EDDSA_PUBLIC_KEY_LEN];
    uint8_t* buf_msg;
    uint8_t* buf_ass[E521_SIGNATURE_LEN];
    char* fnmsg = "";
    char* fnass = "";
    char* fnpub = "";
    int szmsg;
    e521_err_t r;

    FILE *ptr_pub, *ptr_msg, *ptr_ass;
    int ptr_urand;

    if (argc == 4) {
        fnass = argv[1];
        fnmsg = argv[2];
        fnpub = argv[3];
        printf("ass=%s msg=%s kpub=%s", fnass, fnmsg, fnpub);
    } else {
        puts("e521_verify - opes de uso:");
        puts("  e521_verify assinatura.raw arquivo.bin chavepublica.raw [enter] - verificar a assinatura assinatura.raw do arquivo arquivo.bin com a chave privada correspondente  chave pblica chavepublica.raw");
        return 0;
    }

    uint8_t* seed = malloc(len_seed*sizeof(uint8_t));
    ptr_urand = open("/dev/urandom", O_RDONLY);
    read(ptr_urand, seed, len_seed);
    close(ptr_urand);

    r = e521_rng_seed(seed, len_seed);
    printf(" --- resultado ini rng %d", r);

    r = e521_self_test();
    printf(" --- resultado do autoteste %d", r);

    ptr_msg = fopen(fnmsg,"rb");  // handle do arquivo binrio da mensagem
    ptr_pub = fopen(fnpub,"rb");  // handle do arquivo binrio da chave pblica
    ptr_ass = fopen(fnass,"rb");  // handle do arquivo binrio da assinatura
    fseek(ptr_msg, 0L, SEEK_END);
    szmsg = ftell(ptr_msg);
    buf_msg = malloc(szmsg*sizeof(uint8_t));
    rewind(ptr_msg);
    fread(buf_msg, szmsg, 1, ptr_msg);
    fread(kbuf_pub, E521_EDDSA_PUBLIC_KEY_LEN, 1, ptr_pub);
    fread(buf_ass, E521_SIGNATURE_LEN, 1, ptr_ass);

    r = e521_eddsa_verify(buf_ass, E521_SIGNATURE_LEN, buf_msg, szmsg, kbuf_pub, E521_EDDSA_PUBLIC_KEY_LEN);

    if (r == E521_OK) {
        printf(" ---- mensagem no arquivo %s verificada como autntica perante assinatura em %s\n", fnmsg, fnass);
    }
    else {
        printf(" ---- mensagem no arquivo %s verificada com ERRO perante assinatura em %s - erro %2X\n", fnmsg, fnass, r);
    }

    return 0;
}