#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include "e521.h"

int main(int argc, char* argv[])
{
    const int len_seed = 256;

    uint8_t kbuf_priv[E521_EDDSA_PRIVATE_KEY_LEN];
    uint8_t kbuf_pub[E521_EDDSA_PUBLIC_KEY_LEN];

    char* fnprv = "kprv.bin";
    char* fnpub = "kpub.bin";

    e521_err_t r;
    FILE *ptr_prv, *ptr_pub;
    int ptr_urand;

    if (argc == 3) {
        fnprv = argv[1];
        fnpub = argv[2];
    } else {
        if (argc != 1) {
            puts("e521_eddsa_keypair - opes de uso:");
            puts("  e521_eddsa_keypair [enter] - gerar dois arquivos de nome kprv.bin e kpub.bin");
            puts("  e521_eddsa_keypair chaveprivada.raw chavepbublica.raw [enter] - gerar dois arquivos com nomes diferentes de kprv.bin e kpub.bin");
            return 0;
        }
    }

    uint8_t* seed = malloc(len_seed*sizeof(uint8_t));
    ptr_urand = open("/dev/urandom", O_RDONLY);
    read(ptr_urand, seed, len_seed);
    close(ptr_urand);

    r = e521_rng_seed(seed, len_seed);
    printf(" --- resultado ini rng %d", r);

    r = e521_self_test();
    printf(" --- resultado do autoteste %d", r);

    ptr_prv = fopen(fnprv,"wb");  // handle do arquivo binrio da chave privada
    ptr_pub = fopen(fnpub,"wb");  // handle do arquivo binrio da chave pblica

    r = e521_eddsa_keypair(kbuf_pub, sizeof(kbuf_pub), kbuf_priv, sizeof(kbuf_priv));

    fwrite(kbuf_priv, E521_EDDSA_PRIVATE_KEY_LEN, 1, ptr_prv); // escreve a chave privada em seu respectivo arquivo
    fwrite(kbuf_pub, E521_EDDSA_PUBLIC_KEY_LEN, 1, ptr_pub);  // escreve a chave pblica em seu respectivo arquivo

    printf(" ---- gerados os arquivos de chave privada e pblica %s e %s\n", fnprv, fnpub);

    return 0;
}